library(tidyverse)
library(gglot2)

epsilon = c(0.001,0.01,0.02,0.05,0.1,0.5)
y1<-1/2-epsilon/2
y2<-1/2+epsilon/2
y1 <- matrix(rep(y1,100),nrow=6)
y2 <- matrix(rep(y2,100),nrow=6)

x<- runif(100)
plot(x,rep(0,100))

xx <- t(matrix(rep(x,6),nrow=100))
N <- rowSums(y1<xx & xx<y2)

runs <- cbind(epsilon,N)
runs

for(i in c(1:999)){
  x<- runif(100)
  xx <- t(matrix(rep(x,6),nrow=100))
  N <- rowSums(y1<xx & xx<y2)
  runs<-rbind(runs,cbind(epsilon,N))
}


runs=data.frame(runs)

runs %>%
  group_by(epsilon) %>%
  summarise(mean = mean(N))



ggplot(runs,aes(x=N,fill=as.factor(epsilon))) + 
  geom_histogram() +
  facet_wrap(~epsilon)



epsilon = c(0.001,0.01,0.02,0.05,0.1,0.5)
y11<-1/2-epsilon/2
y21<-1/2+epsilon/2
y12<-1/2-epsilon/2
y22<-1/2+epsilon/2
y11 <- matrix(rep(y11,100),nrow=6)
y21 <- matrix(rep(y21,100),nrow=6)
y12 <- matrix(rep(y12,100),nrow=6)
y22 <- matrix(rep(y22,100),nrow=6)

x1<- runif(100)
x2<- runif(100)
plot(x1,x2)

xx1 <- t(matrix(rep(x1,6),nrow=100))
xx2 <- t(matrix(rep(x2,6),nrow=100))
N <- rowSums(y11<xx1 & xx1<y21 & y12<xx2 & xx2<y22)

runs <- cbind(epsilon,N)
runs

for(i in c(1:999)){
  x1<- runif(100)
  x2<- runif(100)
  xx1 <- t(matrix(rep(x1,6),nrow=100))
  xx2 <- t(matrix(rep(x2,6),nrow=100))
  N <- rowSums(y11<xx1 & xx1<y21 & y12<xx2 & xx2<y22)
  runs<-rbind(runs,cbind(epsilon,N))
}


runs=data.frame(runs)

runs %>%
  group_by(epsilon) %>%
  summarise(mean = mean(N))



ggplot(runs,aes(x=N,fill=as.factor(epsilon))) + 
  geom_histogram() +
  facet_wrap(~epsilon)


