# http://rstudio-pubs-static.s3.amazonaws.com/94107_913ae6a497fc408a91a2529b6c57f791.html
library(lle)
library(DMwR)

data("algae")
algae[,12]<-ifelse(algae[,12]<10,0,1)
#test <- sample(1:200,50)

algae.scaled <- data.frame(scale(algae[,-c(1,2,3,13:18)]))

# NEED TO IMPUTE MISSING VALUES
# for now, we remove  observations  with missing values
algae.scaled <- algae.scaled[complete.cases(algae.scaled),]

# construct neighbor matrix
local.nghbs <- find_nn_k(algae.scaled, k=5)
local.nghbs[1:10,1:10]

# calculate weights between x and its neighbors
weights <- find_weights(local.nghbs, algae.scaled, m=2, reg=2)
weights$wgts[1:10, 1:10]

# peform LLE 

# K=5
k5 <- lle(algae.scaled, m=2, k=5, reg=2, ss=FALSE, id=TRUE, v=0.9 )
plot(k5$Y, main="K=5 data", xlab=expression(y[1]), ylab=expression(y[2]))

# K=15
k15 <- lle(algae.scaled, m=2, k=15, reg=2, ss=FALSE, id=TRUE, v=0.9 )
plot(k15$Y, main="K=15 data", xlab=expression(y[1]), ylab=expression(y[2]))

# K=40
k40 <- lle(algae.scaled, m=2, k=40, reg=2, ss=FALSE, id=TRUE, v=0.9 )
plot(k40$Y, main="K=40 data", xlab=expression(y[1]), ylab=expression(y[2]))
