library(kernlab)
library(DMwR)
# another example using the iris
data("algae")
algae[,12]<-ifelse(algae[,12]<10,0,1)
test <- sample(1:200,50)

algae.scaled <- data.frame(scale(algae[,-c(1,2,3,13:18)]))

kpc <- kpca(~.,data=algae.scaled[-test,-9],kernel="rbfdot",
            kpar=list(sigma=0.2),features=2)

#print the principal component vectors
pcv(kpc)

#plot the data projection on the components
plot(rotated(kpc),col=as.integer(algae.scaled[-test,9])+1,
     xlab="1st Principal Component",ylab="2nd Principal Component")

#embed remaining points 
emb <- predict(kpc,algae[test,-12])
points(emb,col=as.integer(iris[test,5]),pch=5)


#Also: https://rstudio-pubs-static.s3.amazonaws.com/285624_ef059fbbe22a4b2db568de1952827b33.html